//GPT-4o-mini DATASET v1.0 Category: Building a SMTP Client ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <errno.h>

#define SMTP_SERVER "smtp.example.com"
#define SMTP_PORT 587
#define BUFFER_SIZE 1024

void error(const char *msg) {
    perror(msg);
    exit(EXIT_FAILURE);
}

void send_command(int sockfd, const char *cmd);
void read_response(int sockfd);
void send_email(int sockfd, const char *from, const char *to, const char *subject, const char *body);

int main() {
    int sockfd;
    struct sockaddr_in server_addr;

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        error("Error opening socket");
    }

    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SMTP_PORT);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1"); // Replace with actual SMTP server IP

    if (connect(sockfd, (struct sockaddr*)&server_addr, sizeof(server_addr)) < 0) {
        error("Connection failed");
    }

    read_response(sockfd);

    send_command(sockfd, "EHLO localhost\r\n");
    read_response(sockfd);

    send_command(sockfd, "STARTTLS\r\n");
    read_response(sockfd);

    // Assuming TLS handshake is done here
    // To implement STARTTLS, you would normally use OpenSSL library

    send_command(sockfd, "AUTH LOGIN\r\n");
    read_response(sockfd);
    
    // Replace with base64 encoded username and password
    send_command(sockfd, "dXNlcm5hbWU=\r\n"); // Base64 for 'username'
    read_response(sockfd);
    
    send_command(sockfd, "cGFzc3dvcmQ=\r\n"); // Base64 for 'password'
    read_response(sockfd);

    const char *from = "sender@example.com";
    const char *to = "recipient@example.com";
    const char *subject = "Hello World";
    const char *body = "This is a test email sent from a C SMTP client.";

    send_email(sockfd, from, to, subject, body);

    send_command(sockfd, "QUIT\r\n");
    read_response(sockfd);

    close(sockfd);
    return 0;
}

void send_command(int sockfd, const char *cmd) {
    if (write(sockfd, cmd, strlen(cmd)) < 0) {
        error("Error sending command");
    }
}

void read_response(int sockfd) {
    char buffer[BUFFER_SIZE];
    ssize_t n = read(sockfd, buffer, sizeof(buffer) - 1);
    if (n < 0) {
        error("Error reading response");
    }
    buffer[n] = '\0';
    printf("%s", buffer);
}

void send_email(int sockfd, const char *from, const char *to, const char *subject, const char *body) {
    send_command(sockfd, "MAIL FROM:<");
    send_command(sockfd, from);
    send_command(sockfd, ">\r\n");
    read_response(sockfd);

    send_command(sockfd, "RCPT TO:<");
    send_command(sockfd, to);
    send_command(sockfd, ">\r\n");
    read_response(sockfd);

    send_command(sockfd, "DATA\r\n");
    read_response(sockfd);

    // Compose email
    send_command(sockfd, "Subject: ");
    send_command(sockfd, subject);
    send_command(sockfd, "\r\n");
    send_command(sockfd, "\r\n"); // Additional blank line
    send_command(sockfd, body);
    send_command(sockfd, "\r\n.\r\n"); // Ending the data section
    read_response(sockfd);
}