//Falcon-180B DATASET v1.0 Category: Math exercise ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.14159265358979323846
#define MIN_RADIUS 0.0001

typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    Point center;
    double radius;
} Circle;

Circle create_circle(double x, double y, double r) {
    Circle c;
    c.center.x = x;
    c.center.y = y;
    c.radius = r;
    return c;
}

double distance(Point p1, Point p2) {
    double dx = p1.x - p2.x;
    double dy = p1.y - p2.y;
    return sqrt(dx * dx + dy * dy);
}

int is_circle_inside_circle(Circle c1, Circle c2) {
    double d = distance(c1.center, c2.center);
    double r1 = c1.radius;
    double r2 = c2.radius;
    if (d <= r1 + r2) {
        return 1;
    } else {
        return 0;
    }
}

int is_circle_touching_circle(Circle c1, Circle c2) {
    double d = distance(c1.center, c2.center);
    double r1 = c1.radius;
    double r2 = c2.radius;
    if (d <= r1 + r2) {
        return 1;
    } else if (d <= r1 + r2 + 2 * MIN_RADIUS) {
        return 2;
    } else {
        return 0;
    }
}

int main() {
    Circle c1 = create_circle(0, 0, 10);
    Circle c2 = create_circle(10, 10, 5);
    int result = is_circle_inside_circle(c1, c2);
    if (result == 1) {
        printf("Circle 1 is inside circle 2.\n");
    } else if (result == 2) {
        printf("Circle 1 is touching circle 2.\n");
    } else {
        printf("Circle 1 is outside circle 2.\n");
    }
    return 0;
}