//GEMINI-pro DATASET v1.0 Category: Stock market tracker ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the maximum number of stocks to track
#define MAX_STOCKS 10

// Define the structure of a stock
typedef struct {
    char symbol[10];       // The stock symbol
    double price;         // The current stock price
    double change;        // The change in stock price since the previous day
} Stock;

// Define the array of stocks to track
Stock stocks[MAX_STOCKS];

// Define the function to generate random stock data
void generate_stock_data() {
    for (int i = 0; i < MAX_STOCKS; i++) {
        // Generate a random stock symbol
        for (int j = 0; j < 10; j++) {
            stocks[i].symbol[j] = 'A' + (rand() % 26);
        }

        // Generate a random stock price
        stocks[i].price = rand() % 1000;

        // Generate a random stock price change
        stocks[i].change = (rand() % 100) / 100.0;
    }
}

// Define the function to print the stock data
void print_stock_data() {
    printf("Stock Symbol\tStock Price\tStock Change\n");
    for (int i = 0; i < MAX_STOCKS; i++) {
        printf("%s\t\t\t%.2f\t\t\t%.2f\n", stocks[i].symbol, stocks[i].price, stocks[i].change);
    }
}

// Define the main function
int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Generate the stock data
    generate_stock_data();

    // Print the stock data
    print_stock_data();

    return 0;
}