//GEMINI-pro DATASET v1.0 Category: System administration ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

// Define the number of child processes to create.
#define NUM_CHILDREN 5

// Define the function that will be executed by the child processes.
void child_process() {
  // Print the process ID of the child process.
  printf("Child process with PID %d.\n", getpid());

  // Sleep for a random amount of time.
  sleep(rand() % 10);

  // Exit the child process.
  exit(0);
}

int main() {
  // Create an array to store the process IDs of the child processes.
  pid_t children[NUM_CHILDREN];

  // Create the child processes.
  for (int i = 0; i < NUM_CHILDREN; i++) {
    children[i] = fork();

    // If the fork() call failed, print an error message and exit.
    if (children[i] == -1) {
      perror("fork() failed");
      exit(1);
    }
    // If the fork() call succeeded, the child process will execute the child_process() function.
    else if (children[i] == 0) {
      child_process();
    }
  }

  // Wait for the child processes to finish executing.
  for (int i = 0; i < NUM_CHILDREN; i++) {
    waitpid(children[i], NULL, 0);
  }

  // Print a message indicating that all of the child processes have finished executing.
  printf("All of the child processes have finished executing.\n");

  return 0;
}