//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_EXERCISES 20
#define MAX_NAME_LENGTH 50

struct exercise {
    char name[MAX_NAME_LENGTH];
    int duration;
};

void add_exercise(struct exercise* exercises, int num_exercises, char* name, int duration) {
    if (num_exercises >= MAX_EXERCISES) {
        printf("Error: Maximum number of exercises reached.\n");
        return;
    }

    strcpy(exercises[num_exercises].name, name);
    exercises[num_exercises].duration = duration;
    num_exercises++;
}

void print_exercises(struct exercise* exercises, int num_exercises) {
    printf("Exercises:\n");
    for (int i = 0; i < num_exercises; i++) {
        printf("%s (%d minutes)\n", exercises[i].name, exercises[i].duration);
    }
}

void start_workout(struct exercise* exercises, int num_exercises) {
    printf("Starting workout...\n");
    for (int i = 0; i < num_exercises; i++) {
        printf("Starting %s...\n", exercises[i].name);
        sleep(exercises[i].duration * 60);
        printf("Finished %s.\n", exercises[i].name);
    }
}

int main() {
    struct exercise exercises[MAX_EXERCISES];
    int num_exercises = 0;

    add_exercise(exercises, num_exercises, "Jogging", 30);
    add_exercise(exercises, num_exercises, "Push-ups", 10);
    add_exercise(exercises, num_exercises, "Sit-ups", 15);

    print_exercises(exercises, num_exercises);

    start_workout(exercises, num_exercises);

    return 0;
}