//Code Llama-13B DATASET v1.0 Category: Warehouse Management System ; Style: invasive
/*
 * Warehouse Management System in C
 * Invasive style
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_NAME_LEN 30

// Struct for storing item information
typedef struct {
  char name[MAX_NAME_LEN];
  int quantity;
  double price;
} Item;

// Function to add an item to the inventory
void addItem(Item inventory[], int *count, char *name, int quantity, double price) {
  // Check if the inventory is full
  if (*count == MAX_ITEMS) {
    printf("Inventory is full. Unable to add more items.\n");
    return;
  }

  // Add the item to the inventory
  strcpy(inventory[*count].name, name);
  inventory[*count].quantity = quantity;
  inventory[*count].price = price;
  (*count)++;
}

// Function to update the quantity of an item in the inventory
void updateQuantity(Item inventory[], int count, char *name, int quantity) {
  // Find the index of the item in the inventory
  int index = -1;
  for (int i = 0; i < count; i++) {
    if (strcmp(inventory[i].name, name) == 0) {
      index = i;
      break;
    }
  }

  // Check if the item was found
  if (index == -1) {
    printf("Item not found in inventory.\n");
    return;
  }

  // Update the quantity of the item
  inventory[index].quantity += quantity;
}

// Function to print the inventory
void printInventory(Item inventory[], int count) {
  printf("Inventory:\n");
  for (int i = 0; i < count; i++) {
    printf("%s (%d): $%.2f\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
  }
}

int main() {
  // Initialize the inventory
  Item inventory[MAX_ITEMS];
  int count = 0;

  // Add some items to the inventory
  addItem(inventory, &count, "Apples", 5, 1.5);
  addItem(inventory, &count, "Bananas", 10, 2.0);
  addItem(inventory, &count, "Oranges", 3, 3.0);

  // Update the quantity of an item
  updateQuantity(inventory, count, "Apples", 10);

  // Print the inventory
  printInventory(inventory, count);

  return 0;
}