//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: rigorous
#include <stdio.h>

// Define a struct to represent a "dragon" with a name and a score
struct dragon {
    char name[20];
    int score;
};

// Define a function to swap two dragons
void swap_dragons(struct dragon *d1, struct dragon *d2) {
    struct dragon temp = *d1;
    *d1 = *d2;
    *d2 = temp;
}

// Define a function to sort an array of dragons using bubble sort
void sort_dragons(struct dragon arr[], int n) {
    int i, j, done = 0;

    // Loop until the array is sorted
    while (!done) {
        done = 1;

        // Loop through the array
        for (i = 0; i < n - 1; i++) {
            // Loop through the array again
            for (j = i + 1; j < n; j++) {
                // If the current dragon is greater than the next one, swap them
                if (arr[i].score > arr[j].score) {
                    swap_dragons(&arr[i], &arr[j]);
                }
            }
        }
    }
}

// Example usage:
int main() {
    struct dragon arr[5] = {
        {"Blaze", 100},
        {"Ember", 50},
        {"Frost", 200},
        {"Glow", 30},
        {"Spark", 40}
    };
    int n = sizeof(arr) / sizeof(arr[0]);

    sort_dragons(arr, n);

    // Print the sorted array
    for (int i = 0; i < n; i++) {
        printf("%s scores %d\n", arr[i].name, arr[i].score);
    }

    return 0;
}