//MISTRAL-7B DATASET v1.0 Category: Queue Implementation ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#define MAX_QUEUE_SIZE 10

typedef struct Queue {
    int items[MAX_QUEUE_SIZE];
    int front;
    int rear;
} Queue;

void initializeQueue(Queue *q) {
    q->front = -1;
    q->rear = -1;
}

int isFull(Queue *q) {
    return (q->rear + 1) % MAX_QUEUE_SIZE == q->front;
}

int isEmpty(Queue *q) {
    return q->front == -1 && q->rear == -1;
}

void enqueue(Queue *q, int item) {
    if (isFull(q)) {
        printf("Queue is full. Cannot enqueue %d.\n", item);
        return;
    }

    if (isEmpty(q)) {
        q->front = 0;
        q->rear = 0;
    } else {
        q->rear = (q->rear + 1) % MAX_QUEUE_SIZE;
    }

    q->items[q->rear] = item;
}

int dequeue(Queue *q) {
    if (isEmpty(q)) {
        printf("Queue is empty. Cannot dequeue.\n");
        return -1;
    }

    int item = q->items[q->front];

    if (q->rear == q->front) {
        q->front = -1;
        q->rear = -1;
    } else {
        q->front = (q->front + 1) % MAX_QUEUE_SIZE;
    }

    return item;
}

int main() {
    Queue queue;
    initializeQueue(&queue);

    enqueue(&queue, 5);
    enqueue(&queue, 10);
    enqueue(&queue, 15);

    printf("Dequeued %d\n", dequeue(&queue));
    printf("Dequeued %d\n", dequeue(&queue));
    printf("Dequeued %d\n", dequeue(&queue));

    enqueue(&queue, 20);
    enqueue(&queue, 25);

    while (!isEmpty(&queue)) {
        printf("Dequeued %d\n", dequeue(&queue));
    }

    return 0;
}