//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

// Define the temperature range
#define MIN_TEMP -20
#define MAX_TEMP 40

// Define the humidity range
#define MIN_HUMIDITY 0
#define MAX_HUMIDITY 100

// Define the wind speed range
#define MIN_WIND_SPEED 0
#define MAX_WIND_SPEED 100

// Define the cloud cover range
#define MIN_CLOUD_COVER 0
#define MAX_CLOUD_COVER 100

// Define the precipitation range
#define MIN_PRECIPITATION 0
#define MAX_PRECIPITATION 100

// Define the weather conditions
typedef enum {
  SUNNY,
  CLOUDY,
  RAINY,
  SNOWY
} weather_condition_t;

// Define the weather structure
typedef struct {
  weather_condition_t condition;
  double temperature;
  double humidity;
  double wind_speed;
  double cloud_cover;
  double precipitation;
} weather_t;

// Generate a random weather condition
weather_condition_t generate_weather_condition() {
  int random_number = rand() % 4;
  switch (random_number) {
    case 0:
      return SUNNY;
    case 1:
      return CLOUDY;
    case 2:
      return RAINY;
    case 3:
      return SNOWY;
    default:
      return SUNNY;
  }
}

// Generate a random temperature
double generate_temperature() {
  return (double) (rand() % (MAX_TEMP - MIN_TEMP + 1)) + MIN_TEMP;
}

// Generate a random humidity
double generate_humidity() {
  return (double) (rand() % (MAX_HUMIDITY - MIN_HUMIDITY + 1)) + MIN_HUMIDITY;
}

// Generate a random wind speed
double generate_wind_speed() {
  return (double) (rand() % (MAX_WIND_SPEED - MIN_WIND_SPEED + 1)) + MIN_WIND_SPEED;
}

// Generate a random cloud cover
double generate_cloud_cover() {
  return (double) (rand() % (MAX_CLOUD_COVER - MIN_CLOUD_COVER + 1)) + MIN_CLOUD_COVER;
}

// Generate a random precipitation
double generate_precipitation() {
  return (double) (rand() % (MAX_PRECIPITATION - MIN_PRECIPITATION + 1)) + MIN_PRECIPITATION;
}

// Generate a random weather
weather_t generate_weather() {
  weather_t weather;
  weather.condition = generate_weather_condition();
  weather.temperature = generate_temperature();
  weather.humidity = generate_humidity();
  weather.wind_speed = generate_wind_speed();
  weather.cloud_cover = generate_cloud_cover();
  weather.precipitation = generate_precipitation();
  return weather;
}

// Print the weather
void print_weather(weather_t weather) {
  switch (weather.condition) {
    case SUNNY:
      printf("The weather is sunny.\n");
      break;
    case CLOUDY:
      printf("The weather is cloudy.\n");
      break;
    case RAINY:
      printf("The weather is rainy.\n");
      break;
    case SNOWY:
      printf("The weather is snowy.\n");
      break;
  }
  printf("The temperature is %.1f degrees Celsius.\n", weather.temperature);
  printf("The humidity is %.1f%%.\n", weather.humidity);
  printf("The wind speed is %.1f kilometers per hour.\n", weather.wind_speed);
  printf("The cloud cover is %.1f%%.\n", weather.cloud_cover);
  printf("The precipitation is %.1f millimeters.\n", weather.precipitation);
}

// Main function
int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Generate a random weather
  weather_t weather = generate_weather();

  // Print the weather
  print_weather(weather);

  return 0;
}