//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

#define AES_KEY_LENGTH 32
#define BLOCK_SIZE 16

void handleErrors(void) {
    printf("An error occurred! Let's try again. 😊\n");
    exit(EXIT_FAILURE);
}

void printHex(const unsigned char *buf, size_t len) {
    for (size_t i = 0; i < len; i++) {
        printf("%02x", buf[i]);
    }
    printf("\n");
}

void generateRandomKey(unsigned char *key) {
    if (!RAND_bytes(key, AES_KEY_LENGTH)) {
        handleErrors();
    }
    printf("Generated a random key! 🎉\n");
}

void encrypt(const unsigned char *plaintext, unsigned char *ciphertext, 
             const unsigned char *key) {
    AES_KEY enc_key;
    if (AES_set_encrypt_key(key, 256, &enc_key) < 0) {
        handleErrors();
    }
    AES_encrypt(plaintext, ciphertext, &enc_key);
    printf("Message encrypted! 💌\n");
}

void decrypt(const unsigned char *ciphertext, unsigned char *plaintext, 
             const unsigned char *key) {
    AES_KEY dec_key;
    if (AES_set_decrypt_key(key, 256, &dec_key) < 0) {
        handleErrors();
    }
    AES_decrypt(ciphertext, plaintext, &dec_key);
    printf("Message decrypted! 🎉😊\n");
}

int main() {
    unsigned char key[AES_KEY_LENGTH];
    unsigned char plaintext[BLOCK_SIZE] = "Hello, World!";
    unsigned char ciphertext[BLOCK_SIZE];
    unsigned char decryptedtext[BLOCK_SIZE];

    printf("Welcome to the Happy Encryption Tool! 🌈\n");
    printf("Your message: %s\n", plaintext);

    generateRandomKey(key);
    
    printf("Plaintext in hex: ");
    printHex(plaintext, BLOCK_SIZE);

    encrypt(plaintext, ciphertext, key);
    printf("Ciphertext in hex: ");
    printHex(ciphertext, BLOCK_SIZE);

    decrypt(ciphertext, decryptedtext, key);
    
    printf("Decrypted text: %s\n", decryptedtext);
    
    if (memcmp(plaintext, decryptedtext, BLOCK_SIZE) == 0) {
        printf("Hooray! The decryption was successful! 🎊\n");
    } else {
        printf("Oh no! The decrypted text does not match the original. 😢\n");
    }

    return 0;
}