//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: realistic
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

void handleErrors(void) {
    fprintf(stderr, "An error occurred.\n");
    exit(EXIT_FAILURE);
}

// Function to encrypt the plaintext using AES
void encrypt(unsigned char *plaintext, unsigned char *key, unsigned char *ciphertext) {
    AES_KEY enc_key;
    if (AES_set_encrypt_key(key, 128, &enc_key) < 0) {
        handleErrors();
    }
    AES_encrypt(plaintext, ciphertext, &enc_key);
}

// Function to decrypt the ciphertext using AES
void decrypt(unsigned char *ciphertext, unsigned char *key, unsigned char *decryptedtext) {
    AES_KEY dec_key;
    if (AES_set_decrypt_key(key, 128, &dec_key) < 0) {
        handleErrors();
    }
    AES_decrypt(ciphertext, decryptedtext, &dec_key);
}

// Function to print the byte array in hexadecimal format
void printHex(unsigned char* buf, int len) {
    for (int i = 0; i < len; i++) {
        printf("%02x", buf[i]);
    }
    printf("\n");
}

int main() {
    // Define a plaintext to be encrypted
    unsigned char plaintext[AES_BLOCK_SIZE] = "HelloWorld12345"; // 16 bytes
    unsigned char ciphertext[AES_BLOCK_SIZE];
    unsigned char decryptedtext[AES_BLOCK_SIZE];

    // Define a key
    unsigned char key[AES_BLOCK_SIZE] = "thisisa16bytekey"; // 16 bytes key for AES-128

    printf("Plaintext: %s\n", plaintext);

    // Encrypt the plaintext
    encrypt(plaintext, key, ciphertext);
    printf("Ciphertext: ");
    printHex(ciphertext, AES_BLOCK_SIZE);

    // Decrypt the ciphertext
    decrypt(ciphertext, key, decryptedtext);
    printf("Decrypted text: %s\n", decryptedtext);

    // Check if the decrypted text matches the original plaintext
    if (strncmp((char *)plaintext, (char *)decryptedtext, AES_BLOCK_SIZE) == 0) {
        printf("Success: Decryption is correct!\n");
    } else {
        printf("Error: Decryption failed!\n");
    }

    return 0;
}