//GEMINI-pro DATASET v1.0 Category: Recursive ; Style: invasive
#include <stdio.h>
#include <stdlib.h>

// Function to print the Fibonacci series
void fibonacci(int n) {
  if (n == 0) {
    printf("0 ");
  } else if (n == 1) {
    printf("1 ");
  } else {
    fibonacci(n - 1);
    fibonacci(n - 2);
  }
}

// Function to print the factorial of a number
int factorial(int n) {
  if (n == 0) {
    return 1;
  } else {
    return n * factorial(n - 1);
  }
}

// Function to print the powers of 2
void powersOf2(int n) {
  if (n == 0) {
    printf("1 ");
  } else {
    powersOf2(n - 1);
    printf("%d ", (1 << n));
  }
}

// Function to print the sum of the digits of a number
int sumOfDigits(int n) {
  if (n == 0) {
    return 0;
  } else {
    return n % 10 + sumOfDigits(n / 10);
  }
}

// Function to print the reverse of a string
void reverseString(char *str) {
  if (*str == '\0') {
    return;
  } else {
    reverseString(str + 1);
    printf("%c", *str);
  }
}

// Function to print the binary representation of a number
void binaryRepresentation(int n) {
  if (n == 0) {
    printf("0");
  } else {
    binaryRepresentation(n / 2);
    printf("%d", n % 2);
  }
}

// Function to print the octal representation of a number
void octalRepresentation(int n) {
  if (n == 0) {
    printf("0");
  } else {
    octalRepresentation(n / 8);
    printf("%d", n % 8);
  }
}

// Function to print the hexadecimal representation of a number
void hexadecimalRepresentation(int n) {
  if (n == 0) {
    printf("0");
  } else {
    hexadecimalRepresentation(n / 16);
    int remainder = n % 16;
    if (remainder < 10) {
      printf("%d", remainder);
    } else {
      printf("%c", remainder + 55);
    }
  }
}

int main() {
  // Print the Fibonacci series
  printf("Fibonacci series: ");
  fibonacci(10);
  printf("\n");

  // Print the factorial of a number
  int num = 5;
  printf("Factorial of %d: %d\n", num, factorial(num));

  // Print the powers of 2
  printf("Powers of 2: ");
  powersOf2(10);
  printf("\n");

  // Print the sum of the digits of a number
  int number = 12345;
  printf("Sum of the digits of %d: %d\n", number, sumOfDigits(number));

  // Print the reverse of a string
  char str[] = "Hello";
  printf("Reverse of \"%s\": ", str);
  reverseString(str);
  printf("\n");

  // Print the binary representation of a number
  int number2 = 10;
  printf("Binary representation of %d: ", number2);
  binaryRepresentation(number2);
  printf("\n");

  // Print the octal representation of a number
  printf("Octal representation of %d: ", number2);
  octalRepresentation(number2);
  printf("\n");

  // Print the hexadecimal representation of a number
  printf("Hexadecimal representation of %d: ", number2);
  hexadecimalRepresentation(number2);
  printf("\n");

  return 0;
}