//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Callback function for writing response data to a file
size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp) {
    size_t realsize = size * nmemb;
    FILE *file = (FILE *)userp;
    return fwrite(contents, realsize, 1, file);
}

// Function for performing HTTP GET request
int PerformGetRequest(const char *url, FILE *file) {
    CURL *curl;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if (curl) {
        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, file);

        res = curl_easy_perform(curl);

        if (res!= CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(res));
        }

        curl_easy_cleanup(curl);
    }

    curl_global_cleanup();

    return res;
}

int main() {
    FILE *file;
    int res;

    // Open output file
    file = fopen("response.txt", "wb");
    if (!file) {
        fprintf(stderr, "Failed to open output file\n");
        return 1;
    }

    // Perform GET request
    res = PerformGetRequest("https://jsonplaceholder.typicode.com/posts/1", file);

    // Close output file
    fclose(file);

    return res;
}