//MISTRAL-7B DATASET v1.0 Category: Queue Implementation ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_QUEUE_SIZE 10

typedef struct Queue {
    int items[MAX_QUEUE_SIZE];
    int front;
    int rear;
} Queue;

void initQueue(Queue *q) {
    q->front = -1;
    q->rear = -1;
}

int isQueueFull(Queue *q) {
    return (q->rear + 1) % MAX_QUEUE_SIZE == q->front;
}

int enqueue(Queue *q, int item) {
    if (isQueueFull(q)) {
        printf("Oh dear! The queue is full. Can't enqueue %d.\n", item);
        return -1;
    }
    if (q->front == -1) {
        q->front = 0;
    }
    q->rear = (q->rear + 1) % MAX_QUEUE_SIZE;
    q->items[q->rear] = item;
    return 0;
}

int dequeue(Queue *q) {
    if (q->front == -1 || q->front == q->rear) {
        printf("Uh oh! The queue is empty. Can't dequeue.\n");
        return -1;
    }
    int item = q->items[q->front];
    q->front = (q->front + 1) % MAX_QUEUE_SIZE;
    return item;
}

void printQueue(Queue q) {
    printf("The queue is: ");
    if (q.front == -1) {
        printf("Empty.\n");
        return;
    }
    int i = q.front;
    do {
        printf("%d ", q.items[i]);
        i = (i + 1) % MAX_QUEUE_SIZE;
    } while (i != q.rear);
    printf("\n");
}

int main() {
    Queue myQueue;
    initQueue(&myQueue);
    int i;
    for (i = 0; i < 12; i++) {
        enqueue(&myQueue, i);
        if (i < 10) {
            printf("Enqueued %d successfully.\n", i);
        } else {
            printf("Surprise! The queue can handle more items than expected.\n");
        }
    }
    printQueue(myQueue);
    for (i = 0; i < 4; i++) {
        int dequeuedItem = dequeue(&myQueue);
        if (i < 3) {
            printf("Dequeued %d successfully.\n", dequeuedItem);
        } else {
            printf("Surprise! There's still an item in the queue.\n");
        }
    }
    printQueue(myQueue);
    return 0;
}