//MISTRAL-7B DATASET v1.0 Category: Pixel Art Generator ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 25
#define HEIGHT 10
#define PALETTE_SIZE 16

typedef struct {
    unsigned char r, g, b;
} color;

color palette[PALETTE_SIZE] = {
    {0x00, 0x00, 0x00}, {0x64, 0x00, 0x00}, {0xff, 0x00, 0x00},
    {0x00, 0x64, 0x00}, {0x00, 0xff, 0x00}, {0x64, 0xff, 0x00},
    {0xff, 0xff, 0x00}, {0x00, 0x00, 0x64},
    {0x64, 0x00, 0x64}, {0xff, 0x00, 0x64}, {0x00, 0x64, 0x64},
    {0x00, 0xff, 0x64}, {0x64, 0xff, 0x64}, {0xff, 0xff, 0x64},
    {0x00, 0x00, 0xff}, {0x64, 0x00, 0xff}, {0xff, 0x00, 0xff},
    {0x00, 0x64, 0xff}, {0x00, 0xff, 0xff}, {0x64, 0xff, 0xff},
    {0xff, 0xff, 0xff}
};

void clear_screen() {
    printf("\033[2J"); // Clear the screen
}

void draw_pixel(int x, int y, color c) {
    printf("\033[%d;%dH\033[%dm%dm%dm", y + 1, x + 1, 38, c.r, c.g, c.b);
}

void random_line(int start_x, int end_x, int y) {
    int dx = abs(end_x - start_x);
    int sx = start_x < end_x ? 1 : -1;
    int i;

    for (i = 0; i <= dx; i++) {
        int x = start_x + (i * sx);
        draw_pixel(x, y, palette[rand() % PALETTE_SIZE]);
    }
}

int main() {
    srand(time(NULL));

    clear_screen();

    for (int i = 0; i < HEIGHT; i++) {
        int x1 = rand() % WIDTH;
        int x2 = rand() % WIDTH;

        if (x1 > x2) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
        }

        random_line(x1, x2, i);
    }

    getchar();

    return 0;
}