//MISTRAL-7B DATASET v1.0 Category: Hexadecimal Converter ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_HEX_DIGITS 32
#define MAX_DECIMAL_DIGITS 11
#define HEX_TO_DECIMAL(x) (16 * (int)hexdigit_table[(int)(tolower((unsigned char)(x)) - '0')] + \
                          (isdigit((int)(tolower((unsigned char)(x+1)))) ? \
                           (16 * (int)hexdigit_table[(int)tolower((unsigned char)(x+1))] + \
                            (int)hexdigit_table[(int)tolower((unsigned char)(x+2))]) : \
                           (int)hexdigit_table[(int)tolower((unsigned char)(x+1))]))

const char hexdigit_table[16] = {
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};

void print_hex(unsigned char *hex_buffer, size_t size) {
    size_t i;

    printf("The decimal number %lu is equivalent to the following hexadecimal number:\n", (unsigned long)HEX_TO_DECIMAL(hex_buffer));

    for (i = 0; i < size; i++)
        printf("%.2X", hex_buffer[i]);

    printf("\n");
}

int main() {
    char hex_string[MAX_HEX_DIGITS + 1] = {0};
    unsigned char hex_buffer[MAX_DECIMAL_DIGITS / 2 + 1] = {0};
    int hex_string_length = 0;
    int i = 0;

    printf("Once upon a time, in a land of love and magic numbers,\n");
    printf("There was a hexadecimal number, hidden and untold,\n");
    printf("Only the bravest of hearts could unveil its might,\n");
    printf("So gather around, my dearest, and hold my hand tight.\n\n");

    while (hex_string[hex_string_length] != '\0') {
        if (isxdigit(hex_string[hex_string_length])) {
            if (hex_string_length > MAX_HEX_DIGITS) {
                printf("Oh dear, too many digits, my love! Exit the stage left.\n");
                return 1;
            }
            hex_buffer[i++] = hex_string[hex_string_length];
        }
        hex_string_length++;
    }

    hex_buffer[i] = '\0';

    for (i = 0; i < hex_string_length / 2; i += 2) {
        if (hex_buffer[i] > '9') {
            hex_buffer[i] -= 0x20;
        }
        if (hex_buffer[i+1] > '9') {
            hex_buffer[i+1] -= 0x20;
        }
        print_hex(hex_buffer, i+1);
    }

    printf("And the hexadecimal number lived happily ever after,\n");
    printf("With the love of its beholder, who knew its secrets and worth.\n");

    return 0;
}