//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define RED 0
#define YELLOW 1
#define GREEN 2

#define NS 0
#define EW 1
#define NONE 2

#define DELAY 1

// Define the traffic light system
int trafficLight(int direction, int state) {
    if (direction == NS && state == GREEN) {
        printf("Traffic light is green for North-South\n");
    } else if (direction == EW && state == GREEN) {
        printf("Traffic light is green for East-West\n");
    } else {
        printf("Traffic light is red\n");
    }
}

// Define the traffic controller
void trafficController(int direction) {
    int state = RED; // Initialize the traffic light state to red
    int count = 0; // Initialize the count of seconds to zero

    // Start the traffic light timer
    while (count < 60) {
        trafficLight(direction, state); // Call the traffic light function with the current state
        count++; // Increment the count of seconds
        if (count == 60) { // If the count reaches 60 seconds, change the traffic light state
            state++;
            if (state > GREEN) { // If the state is greater than green (i.e. yellow), reset it to red
                state = RED;
            }
        }
        sleep(DELAY); // Sleep for 1 second
    }
}

int main() {
    srand(time(NULL)); // Seed the random number generator with the current time
    int direction = rand() % 3; // Generate a random direction (0 for North-South, 1 for East-West, 2 for None)
    if (direction!= NONE) { // If the direction is not None, start the traffic controller
        trafficController(direction);
    }
    return 0;
}