//GPT-4o-mini DATASET v1.0 Category: Pattern printing ; Style: futuristic
#include <stdio.h>
#include <unistd.h>

void futuristicPattern(int n) {
    // Loop for each row
    for (int i = 0; i < n; i++) {
        // Printing leading spaces
        for (int j = 0; j < n - i - 1; j++) {
            printf(" ");
        }
        // Printing stars and spaces in a futuristic wave pattern
        for (int j = 0; j < 2 * i + 1; j++) {
            if (j % 2 == 0) {
                printf("★"); // Star character for even indices
            } else {
                printf(" "); // Space for odd indices
            }
        }
        printf("\n"); // Move to the next line
        usleep(50000); // Adding delay for visual effect
    }
}

void waveEffect(int n) {
    // Creating an illusion of waves through printing
    for (int row = 0; row < n; row++) {
        for (int col = 0; col < row; col++) {
            printf(" ");
        }
        printf("▓"); // Start of the wave
        for (int col = row; col < n * 2 - 1; col++) {
            printf("░"); // Fill the rest with light gradient
        }
        printf("\n");
        usleep(50000); // Delay for visual effect
    }
}

int main() {
    int n = 10; // Height of the pattern
    printf("Generating Futuristic Wave Pattern...\n\n");

    // Call the futuristic star pattern function
    futuristicPattern(n);

    // Call the wave effect function
    waveEffect(n);
    
    printf("\nFuturistic pattern finished!\n");
    return 0;
}