//GEMINI-pro DATASET v1.0 Category: Matrix operations ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>

// Define the size of the matrices
#define ROWS 3
#define COLUMNS 3

// Define the matrices
int matrixA[ROWS][COLUMNS] = {
    {1, 2, 3},
    {4, 5, 6},
    {7, 8, 9}
};

int matrixB[ROWS][COLUMNS] = {
    {9, 8, 7},
    {6, 5, 4},
    {3, 2, 1}
};

// Define the result matrix
int result[ROWS][COLUMNS];

// Function to add two matrices
void addMatrices(int matrixA[ROWS][COLUMNS], int matrixB[ROWS][COLUMNS], int result[ROWS][COLUMNS]) {
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLUMNS; j++) {
            result[i][j] = matrixA[i][j] + matrixB[i][j];
        }
    }
}

// Function to subtract two matrices
void subtractMatrices(int matrixA[ROWS][COLUMNS], int matrixB[ROWS][COLUMNS], int result[ROWS][COLUMNS]) {
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLUMNS; j++) {
            result[i][j] = matrixA[i][j] - matrixB[i][j];
        }
    }
}

// Function to multiply two matrices
void multiplyMatrices(int matrixA[ROWS][COLUMNS], int matrixB[ROWS][COLUMNS], int result[ROWS][COLUMNS]) {
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLUMNS; j++) {
            result[i][j] = 0;
            for (int k = 0; k < COLUMNS; k++) {
                result[i][j] += matrixA[i][k] * matrixB[k][j];
            }
        }
    }
}

// Function to print a matrix
void printMatrix(int matrix[ROWS][COLUMNS]) {
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLUMNS; j++) {
            printf("%d ", matrix[i][j]);
        }
        printf("\n");
    }
}

// Main function
int main() {
    // Add the two matrices
    addMatrices(matrixA, matrixB, result);

    // Print the result
    printf("The sum of the two matrices is:\n");
    printMatrix(result);

    // Subtract the two matrices
    subtractMatrices(matrixA, matrixB, result);

    // Print the result
    printf("\nThe difference of the two matrices is:\n");
    printMatrix(result);

    // Multiply the two matrices
    multiplyMatrices(matrixA, matrixB, result);

    // Print the result
    printf("\nThe product of the two matrices is:\n");
    printMatrix(result);

    return 0;
}