//Gemma-7B DATASET v1.0 Category: Breakout Game Clone ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_WIDTH 10
#define MAX_HEIGHT 10

#define BALL_SIZE 5
#define PADDLE_SIZE 20

typedef struct Ball {
    int x, y;
    int dx, dy;
} Ball;

typedef struct Paddle {
    int x, y;
    int dx, dy;
} Paddle;

Ball ball;
Paddle paddle;

void initialize() {
    srand(time(NULL));

    ball.x = MAX_WIDTH / 2;
    ball.y = MAX_HEIGHT - 1;
    ball.dx = rand() % 3 - 1;
    ball.dy = -1;

    paddle.x = MAX_WIDTH / 2 - PADDLE_SIZE / 2;
    paddle.y = MAX_HEIGHT - 1;
    paddle.dx = 0;
    paddle.dy = 0;
}

void move_ball() {
    ball.x += ball.dx * 0.05;
    ball.y += ball.dy * 0.05;

    if (ball.x >= MAX_WIDTH - BALL_SIZE || ball.x <= 0) {
        ball.dx *= -1;
    }

    if (ball.y <= 0) {
        ball.dy *= -1;
    }
}

void move_paddle() {
    int key = getchar();

    switch (key) {
        case 'w':
            paddle.y--;
            break;
        case 's':
            paddle.y++;
            break;
    }

    if (paddle.y >= MAX_HEIGHT - PADDLE_SIZE) {
        paddle.y = MAX_HEIGHT - PADDLE_SIZE;
    }

    if (paddle.y <= 0) {
        paddle.y = 0;
    }
}

void draw() {
    system("cls");

    for (int y = 0; y < MAX_HEIGHT; y++) {
        for (int x = 0; x < MAX_WIDTH; x++) {
            if (x == ball.x && y == ball.y) {
                printf("O ");
            } else if (x == paddle.x && y == paddle.y) {
                printf("P ");
            } else {
                printf(". ");
            }
        }

        printf("\n");
    }
}

int main() {
    initialize();

    while (!ball.y) {
        move_ball();
        move_paddle();
        draw();
    }

    return 0;
}