//GPT-4o-mini DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <semaphore.h>
#include <time.h>

#define NUM_BAGGAGE 10
#define CONVEYOR_BELT_LENGTH 5

sem_t empty, full; // Semaphores for buffer
int conveyorBelt[CONVEYOR_BELT_LENGTH];
int in = 0, out = 0;

// Function for baggage drop-off
void* baggageDrop(void* arg) {
    for (int i = 0; i < NUM_BAGGAGE; i++) {
        int baggageID = rand() % 1000; // generate random baggage ID
        sem_wait(&empty); // wait until there's space on the conveyor belt

        // Simulate baggage drop
        conveyorBelt[in] = baggageID;
        printf("Baggage %d dropped off at position %d\n", baggageID, in);
        in = (in + 1) % CONVEYOR_BELT_LENGTH;

        sem_post(&full); // signal that there's a new baggage on the belt
        sleep(rand() % 2 + 1); // Random delay (1-2 seconds)
    }
    return NULL;
}

// Function for baggage pick-up
void* baggagePickup(void* arg) {
    for (int i = 0; i < NUM_BAGGAGE; i++) {
        sem_wait(&full); // wait until there's baggage to pick up

        // Simulate baggage pick-up
        int baggageID = conveyorBelt[out];
        printf("Baggage %d picked up from position %d\n", baggageID, out);
        out = (out + 1) % CONVEYOR_BELT_LENGTH;

        sem_post(&empty); // signal there's space on the belt
        sleep(rand() % 2 + 1); // Random delay (1-2 seconds)
    }
    return NULL;
}

int main() {
    srand(time(NULL)); // Seed for randomness

    // Initialize semaphores
    sem_init(&empty, 0, CONVEYOR_BELT_LENGTH); // Initialize the empty semaphore
    sem_init(&full, 0, 0); // Initialize the full semaphore

    pthread_t dropper, picker;

    // Create threads for baggage drop-off and pick-up
    pthread_create(&dropper, NULL, baggageDrop, NULL);
    pthread_create(&picker, NULL, baggagePickup, NULL);

    // Wait for threads to finish
    pthread_join(dropper, NULL);
    pthread_join(picker, NULL);

    // Clean up semaphores
    sem_destroy(&empty);
    sem_destroy(&full);

    return 0;
}