//MISTRAL-7B DATASET v1.0 Category: Poker Game ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_CARDS 5
#define SUITS 4
#define CARD_SIZE 2

typedef struct Card {
    int value;
    int suit;
} Card;

void print_card(Card card) {
    const char *suits[] = {"Hearts", "Diamonds", "Clubs", "Spades"};
    const char *values[] = {"Ace", "2", "3", "4", "5", "6", "7", "8", "9", "10", "Jack", "Queen", "King"};

    printf("%s %s", values[card.value - 1], suits[card.suit]);
}

Card draw_card() {
    Card card;
    card.value = rand() % 13 + 1;
    card.suit = rand() % SUITS;
    return card;
}

void print_hand(Card hand[NUM_CARDS]) {
    int i;

    printf("Your hand:\n");
    for (i = 0; i < NUM_CARDS; i++) {
        print_card(hand[i]);
        printf(i < NUM_CARDS - 1 ? ", " : ".\n");
    }
}

int main() {
    Card player[NUM_CARDS], dealer[NUM_CARDS];
    int i;

    srand(time(NULL));

    for (i = 0; i < NUM_CARDS; i++) {
        player[i] = draw_card();
        dealer[i] = draw_card();
    }

    print_hand(player);
    print_hand(dealer);

    /* TODO: Implement poker logic here */

    return 0;
}