//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DAYS 7
#define TEMP_MIN -20
#define TEMP_MAX 40
#define HUMIDITY_MIN 0
#define HUMIDITY_MAX 100
#define WIND_MIN 0
#define WIND_MAX 150
#define VISIBILITY_MIN 0
#define VISIBILITY_MAX 10

typedef struct {
    int temperature;  // in degrees Celsius
    int humidity;     // percentage
    int windSpeed;    // in km/h
    float visibility; // in km
} WeatherInfo;

void generateWeather(WeatherInfo* weather) {
    if (weather == NULL) {
        fprintf(stderr, "Invalid pointer provided to generateWeather\n");
        return;
    }
    weather->temperature = rand() % (TEMP_MAX - TEMP_MIN + 1) + TEMP_MIN;
    weather->humidity = rand() % (HUMIDITY_MAX - HUMIDITY_MIN + 1) + HUMIDITY_MIN;
    weather->windSpeed = rand() % (WIND_MAX - WIND_MIN + 1) + WIND_MIN;
    weather->visibility = (rand() % (VISIBILITY_MAX * 10 + 1)) / 10.0;  // generates float up to 10.0
}

void displayWeather(const WeatherInfo* weather, int day) {
    if (weather == NULL) {
        fprintf(stderr, "Invalid pointer provided to displayWeather\n");
        return;
    }
    printf("Day %d:\n", day + 1);
    printf("Temperature: %d°C\n", weather->temperature);
    printf("Humidity: %d%%\n", weather->humidity);
    printf("Wind Speed: %d km/h\n", weather->windSpeed);
    printf("Visibility: %.1f km\n", weather->visibility);
    printf("-------------------------------\n");
}

int main() {
    srand(time(NULL));  // Seed for random number generation

    WeatherInfo* sevenDayForecast = malloc(DAYS * sizeof(WeatherInfo));
    if (sevenDayForecast == NULL) {
        fprintf(stderr, "Memory allocation failed\n");
        return EXIT_FAILURE;
    }

    for (int day = 0; day < DAYS; day++) {
        generateWeather(&sevenDayForecast[day]);
    }

    printf("7-Day Weather Forecast:\n");
    printf("-------------------------------\n");
    for (int day = 0; day < DAYS; day++) {
        displayWeather(&sevenDayForecast[day], day);
    }

    free(sevenDayForecast);
    return EXIT_SUCCESS;
}