//GEMINI-pro DATASET v1.0 Category: Banking Record System ; Style: visionary
#include <stdio.h>
#include <stdlib.h>

#define MAX_ACCOUNTS 100
#define MAX_TRANSACTIONS 1000

typedef struct {
  int account_number;
  char *name;
  double balance;
} account_t;

typedef struct {
  int account_number;
  double amount;
  char *description;
} transaction_t;

// Global variables
account_t accounts[MAX_ACCOUNTS];
transaction_t transactions[MAX_TRANSACTIONS];
int num_accounts = 0;
int num_transactions = 0;

// Function prototypes
void create_account(int account_number, char *name, double balance);
void deposit(int account_number, double amount, char *description);
void withdraw(int account_number, double amount, char *description);
void print_statement(int account_number);

int main() {
  // Create some sample accounts
  create_account(12345, "John Doe", 1000.00);
  create_account(54321, "Jane Doe", 500.00);

  // Deposit some money into John's account
  deposit(12345, 500.00, "Paycheck");

  // Withdraw some money from Jane's account
  withdraw(54321, 200.00, "Rent");

  // Print John's statement
  print_statement(12345);

  // Print Jane's statement
  print_statement(54321);

  return 0;
}

void create_account(int account_number, char *name, double balance) {
  // Check if the account number is already in use
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      printf("Error: Account number %d already exists.\n", account_number);
      return;
    }
  }

  // Create the new account
  accounts[num_accounts].account_number = account_number;
  accounts[num_accounts].name = name;
  accounts[num_accounts].balance = balance;
  num_accounts++;
}

void deposit(int account_number, double amount, char *description) {
  // Find the account
  int account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      account_index = i;
      break;
    }
  }

  // Check if the account was found
  if (account_index == -1) {
    printf("Error: Account number %d not found.\n", account_number);
    return;
  }

  // Create the transaction
  transactions[num_transactions].account_number = account_number;
  transactions[num_transactions].amount = amount;
  transactions[num_transactions].description = description;
  num_transactions++;

  // Update the account balance
  accounts[account_index].balance += amount;
}

void withdraw(int account_number, double amount, char *description) {
  // Find the account
  int account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      account_index = i;
      break;
    }
  }

  // Check if the account was found
  if (account_index == -1) {
    printf("Error: Account number %d not found.\n", account_number);
    return;
  }

  // Check if the account has enough funds
  if (accounts[account_index].balance < amount) {
    printf("Error: Insufficient funds in account %d.\n", account_number);
    return;
  }

  // Create the transaction
  transactions[num_transactions].account_number = account_number;
  transactions[num_transactions].amount = -amount;
  transactions[num_transactions].description = description;
  num_transactions++;

  // Update the account balance
  accounts[account_index].balance -= amount;
}

void print_statement(int account_number) {
  // Find the account
  int account_index = -1;
  for (int i = 0; i < num_accounts; i++) {
    if (accounts[i].account_number == account_number) {
      account_index = i;
      break;
    }
  }

  // Check if the account was found
  if (account_index == -1) {
    printf("Error: Account number %d not found.\n", account_number);
    return;
  }

  // Print the account information
  printf("Account Number: %d\n", accounts[account_index].account_number);
  printf("Name: %s\n", accounts[account_index].name);
  printf("Balance: $%.2f\n", accounts[account_index].balance);

  // Print the transactions
  printf("Transactions:\n");
  for (int i = 0; i < num_transactions; i++) {
    if (transactions[i].account_number == account_number) {
      printf("  %s: $%.2f\n", transactions[i].description, transactions[i].amount);
    }
  }
}