//Falcon-180B DATASET v1.0 Category: Greedy Algorithms ; Style: complete
#include <stdio.h>
#include <stdlib.h>

// Function to find the maximum coin value that can be used
int findMaxCoin(int* coins, int numCoins) {
    int max = coins[0];
    for (int i = 1; i < numCoins; i++) {
        if (coins[i] > max) {
            max = coins[i];
        }
    }
    return max;
}

// Function to find the maximum combination of coins that can be used
int findMaxCombination(int* coins, int numCoins, int target) {
    int max = 0;
    for (int i = numCoins - 1; i >= 0; i--) {
        if (coins[i] <= target) {
            target -= coins[i];
            max += coins[i];
        }
    }
    return max;
}

// Function to find the minimum number of coins needed to make a given amount
int findMinCoins(int* coins, int numCoins, int target) {
    int min = 0;
    for (int i = 0; i < numCoins; i++) {
        if (target >= coins[i]) {
            target -= coins[i];
            min++;
        }
    }
    return min;
}

int main() {
    int coins[] = {1, 5, 10, 25};
    int numCoins = sizeof(coins) / sizeof(coins[0]);

    int target = 63;

    // Find the maximum coin value that can be used
    int maxCoin = findMaxCoin(coins, numCoins);

    // Find the maximum combination of coins that can be used
    int maxCombination = findMaxCombination(coins, numCoins, target);

    // Find the minimum number of coins needed to make the target amount
    int minCoins = findMinCoins(coins, numCoins, target);

    printf("Max coin value: %d\n", maxCoin);
    printf("Max coin combination: %d\n", maxCombination);
    printf("Min coins needed: %d\n", minCoins);

    return 0;
}