//GPT-4o-mini DATASET v1.0 Category: System boot optimizer ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <string.h>

#define NUM_TASKS 5

// Structure to hold task information
typedef struct {
    char taskName[30];
    void (*taskFunction)(void);
} Task;

// Mutex for ensuring exclusive access to shared resources
pthread_mutex_t mutex;

// Sample task functions
void defragment() {
    pthread_mutex_lock(&mutex);
    printf("Performing disk defragmentation...\n");
    sleep(2); // Simulating time-consuming operation
    printf("Disk defragmentation completed.\n");
    pthread_mutex_unlock(&mutex);
}

void clearCache() {
    pthread_mutex_lock(&mutex);
    printf("Clearing system cache...\n");
    sleep(1); // Simulating time-consuming operation
    printf("System cache cleared.\n");
    pthread_mutex_unlock(&mutex);
}

void optimizeStartupPrograms() {
    pthread_mutex_lock(&mutex);
    printf("Optimizing startup programs...\n");
    sleep(3); // Simulating time-consuming operation
    printf("Startup programs optimized.\n");
    pthread_mutex_unlock(&mutex);
}

void updateDrivers() {
    pthread_mutex_lock(&mutex);
    printf("Updating drivers...\n");
    sleep(2); // Simulating time-consuming operation
    printf("Drivers updated.\n");
    pthread_mutex_unlock(&mutex);
}

void runSystemDiagnostics() {
    pthread_mutex_lock(&mutex);
    printf("Running system diagnostics...\n");
    sleep(2); // Simulating time-consuming operation
    printf("System diagnostics completed.\n");
    pthread_mutex_unlock(&mutex);
}

// Array of tasks
Task tasks[NUM_TASKS] = {
    {"Defragment", defragment},
    {"Clear Cache", clearCache},
    {"Optimize Startup Programs", optimizeStartupPrograms},
    {"Update Drivers", updateDrivers},
    {"Run System Diagnostics", runSystemDiagnostics}
};

// Function for each thread
void* executeTask(void* arg) {
    Task* task = (Task*)arg;
    task->taskFunction();
    return NULL;
}

int main() {
    pthread_t threads[NUM_TASKS];
    int rc;

    // Initialize mutex
    if (pthread_mutex_init(&mutex, NULL) != 0) {
        fprintf(stderr, "Mutex initialization failed\n");
        return 1;
    }

    // Create and execute threads for each task
    for (int i = 0; i < NUM_TASKS; i++) {
        printf("Starting task: %s\n", tasks[i].taskName);
        rc = pthread_create(&threads[i], NULL, executeTask, (void*)&tasks[i]);
        if (rc) {
            fprintf(stderr, "Error creating thread %d\n", i);
            return 1;
        }
    }

    // Wait for all threads to finish
    for (int i = 0; i < NUM_TASKS; i++) {
        pthread_join(threads[i], NULL);
    }

    // Clean up mutex
    pthread_mutex_destroy(&mutex);

    printf("All tasks completed successfully.\n");
    return 0;
}