//MISTRAL-7B DATASET v1.0 Category: Searching algorithm ; Style: creative
#include <stdio.h>
#include <stdlib.h>

// Custom Comparator Function
int compare_silly(int x, int y) {
    const char *x_name = (x > y) ? "Bigger Fox" : "Littler Box";
    const char *y_name = (x > y) ? "Littler Box" : "Bigger Fox";

    printf("\nComparing %d (%s) and %d (%s):\n", x, x_name, y, y_name);
    return (x > y) ? 1 : -1;
}

// Silly Binary Search Function
int silly_binary_search(int arr[], int size, int target) {
    int low = 0, high = size - 1;
    int mid;
    int result;

    while (low <= high) {
        mid = low + (high - low) / 2;

        result = compare_silly(arr[mid], target);

        if (result == 0) {
            printf("\nFound %d at index %d!\n", target, mid);
            return mid;
        }

        if (result == 1) {
            printf("Silly %d is a Bigger Fox, searching left side...\n", arr[mid]);
            high = mid - 1;
        } else {
            printf("Silly %d is a Littler Box, searching right side...\n", arr[mid]);
            low = mid + 1;
        }
    }

    printf("Silly %d is not present in the array!", target);
    return -1;
}

int main() {
    int arr[] = {1, 3, 5, 7, 9, 11, 13, 15};
    int size = sizeof(arr) / sizeof(arr[0]);
    int target = 7;

    silly_binary_search(arr, size, target);

    return 0;
}