//Code Llama-13B DATASET v1.0 Category: Cafe Billing System ; Style: beginner-friendly
/*
 * Cafe Billing System
 *
 * A beginner-friendly example program for a cafe billing system.
 */

#include <stdio.h>
#include <string.h>

// Struct to represent a cafe item
struct item {
    char name[50];
    double price;
};

// Struct to represent a cafe order
struct order {
    char name[50];
    struct item items[50];
    int num_items;
};

// Function to print an order
void print_order(struct order *order) {
    printf("Order: %s\n", order->name);
    for (int i = 0; i < order->num_items; i++) {
        printf("  %d. %s - $%.2f\n", i + 1, order->items[i].name, order->items[i].price);
    }
}

// Function to calculate the total price of an order
double calculate_total(struct order *order) {
    double total = 0.0;
    for (int i = 0; i < order->num_items; i++) {
        total += order->items[i].price;
    }
    return total;
}

int main() {
    // Declare and initialize a cafe item array
    struct item items[50] = {
        {"Coffee", 3.00},
        {"Tea", 2.50},
        {"Sandwich", 5.00},
        {"Cake", 4.00},
        {"Pastry", 3.50},
        {"Beverage", 1.50}
    };

    // Declare and initialize a cafe order
    struct order order = {
        "John Doe",
        items,
        3
    };

    // Print the order
    print_order(&order);

    // Calculate the total price of the order
    double total = calculate_total(&order);
    printf("Total: $%.2f\n", total);

    return 0;
}