//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define NUM_THREADS 3
#define SHAPES 3
#define ITERATIONS 5

// Enum for shapes
typedef enum {
    CIRCLE,
    SQUARE,
    TRIANGLE,
    SHAPE_COUNT
} Shape;

// Structure to hold thread information
typedef struct {
    int thread_id;
    Shape current_shape;
} ThreadData;

// Function to print the shape
void print_shape(Shape shape) {
    switch (shape) {
        case CIRCLE:
            printf("Circle\n");
            break;
        case SQUARE:
            printf("Square\n");
            break;
        case TRIANGLE:
            printf("Triangle\n");
            break;
        default:
            printf("Unknown Shape\n");
            break;
    }
}

// Thread function to simulate shape shifting
void* shape_shift(void* arg) {
    ThreadData* data = (ThreadData*)arg;
    for (int i = 0; i < ITERATIONS; i++) {
        printf("Thread %d: ", data->thread_id);
        print_shape(data->current_shape);
        
        // Shape shifting logic
        data->current_shape = (data->current_shape + 1) % SHAPES;
        
        // Sleep for a while to simulate work
        sleep(rand() % 3 + 1); // Sleep between 1 to 3 seconds
    }
    return NULL;
}

int main() {
    pthread_t threads[NUM_THREADS];
    ThreadData thread_data[NUM_THREADS];

    // Initialize random seed
    srand(time(NULL));

    // Create threads
    for (int i = 0; i < NUM_THREADS; i++) {
        thread_data[i].thread_id = i;
        thread_data[i].current_shape = (Shape)(rand() % SHAPES);
        pthread_create(&threads[i], NULL, shape_shift, (void*)&thread_data[i]);
    }

    // Wait for threads to finish
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("All threads have finished shape shifting!\n");
    return 0;
}