//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_DAYS 30

typedef struct {
    int day;
    float temperature;
    float humidity;
    float precipitation;
    float wind_speed;
} WeatherData;

int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Create an array to store the weather data
    WeatherData weather_data[NUM_DAYS];

    // Generate the weather data
    for (int i = 0; i < NUM_DAYS; i++) {
        // Generate the day of the month
        weather_data[i].day = i + 1;

        // Generate the temperature
        weather_data[i].temperature = 10 + (rand() % 20);

        // Generate the humidity
        weather_data[i].humidity = 30 + (rand() % 30);

        // Generate the precipitation
        if (rand() % 100 < 20) {
            weather_data[i].precipitation = 0.1 + (rand() % 1);
        } else {
            weather_data[i].precipitation = 0;
        }

        // Generate the wind speed
        weather_data[i].wind_speed = 5 + (rand() % 10);
    }

    // Print the weather data
    printf("Weather Data for the Next %d Days\n", NUM_DAYS);
    printf("-----------------------------------------------------\n");
    printf("Day\tTemp\tHumidity\tPrecip\tWindSpeed\n");
    for (int i = 0; i < NUM_DAYS; i++) {
        printf("%d\t%.1f\t%.1f%%\t%.1fmm\t%.1fkm/h\n", weather_data[i].day, weather_data[i].temperature, weather_data[i].humidity, weather_data[i].precipitation, weather_data[i].wind_speed);
    }

    return 0;
}