//Falcon-180B DATASET v1.0 Category: Database querying ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

#define MAX_SQL_LENGTH 1000

static int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

int main() {
    sqlite3 *db;
    char *zErrMsg = 0;
    int rc;

    rc = sqlite3_open("test.db", &db);

    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    char sql[MAX_SQL_LENGTH];
    snprintf(sql, MAX_SQL_LENGTH, "CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY, name TEXT, age INTEGER);");
    char *errMsg = 0;

    rc = sqlite3_exec(db, sql, 0, 0, &errMsg);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Table created successfully\n");
    }

    sqlite3_stmt *stmt;
    snprintf(sql, MAX_SQL_LENGTH, "INSERT INTO users (name, age) VALUES ('John', 30);");
    rc = sqlite3_prepare_v2(db, sql, -1, &stmt, 0);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
    } else {
        rc = sqlite3_step(stmt);

        if (rc!= SQLITE_DONE) {
            fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
        } else {
            printf("Record inserted successfully\n");
        }

        sqlite3_finalize(stmt);
    }

    snprintf(sql, MAX_SQL_LENGTH, "SELECT * FROM users;");
    rc = sqlite3_prepare_v2(db, sql, -1, &stmt, 0);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
    } else {
        rc = sqlite3_step(stmt);

        if (rc == SQLITE_ROW) {
            printf("Query executed successfully\n");
            sqlite3_exec(db, "DROP TABLE users;", 0, 0, &errMsg);
        } else {
            fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
        }

        sqlite3_finalize(stmt);
    }

    sqlite3_close(db);

    return 0;
}