//Code Llama-13B DATASET v1.0 Category: Electronic Voting System ; Style: scalable
/*
 *  Electronic Voting System
 *  Author: [Your Name]
 *  Date: [Date]
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 100
#define MAX_VOTERS 1000
#define MAX_VOTES 10000

// Structure to store candidate information
typedef struct {
  char name[50];
  int votes;
} candidate_t;

// Structure to store voter information
typedef struct {
  char name[50];
  int voted;
} voter_t;

// Function to print the results
void print_results(candidate_t candidates[], int num_candidates, voter_t voters[], int num_voters) {
  int i, j;

  // Print the results for each candidate
  for (i = 0; i < num_candidates; i++) {
    printf("Candidate %d: %s (%d votes)\n", i + 1, candidates[i].name, candidates[i].votes);
  }

  // Print the results for each voter
  for (i = 0; i < num_voters; i++) {
    printf("Voter %d: %s (", i + 1, voters[i].name);
    for (j = 0; j < num_candidates; j++) {
      if (voters[i].voted & (1 << j)) {
        printf("%s, ", candidates[j].name);
      }
    }
    printf(")\n");
  }
}

// Function to cast a vote
void cast_vote(candidate_t candidates[], int num_candidates, voter_t voters[], int num_voters, int candidate_id, int voter_id) {
  // Check if the candidate is valid
  if (candidate_id < 1 || candidate_id > num_candidates) {
    printf("Invalid candidate ID\n");
    return;
  }

  // Check if the voter is valid
  if (voter_id < 1 || voter_id > num_voters) {
    printf("Invalid voter ID\n");
    return;
  }

  // Check if the voter has already voted
  if (voters[voter_id - 1].voted) {
    printf("Voter has already voted\n");
    return;
  }

  // Cast the vote
  candidates[candidate_id - 1].votes++;
  voters[voter_id - 1].voted = 1;
}

int main() {
  // Initialize the candidates and voters
  candidate_t candidates[MAX_CANDIDATES];
  voter_t voters[MAX_VOTERS];
  int num_candidates = 0, num_voters = 0;

  // Add candidates
  candidates[num_candidates++] = (candidate_t){ "John Doe", 0 };
  candidates[num_candidates++] = (candidate_t){ "Jane Doe", 0 };
  candidates[num_candidates++] = (candidate_t){ "John Smith", 0 };

  // Add voters
  voters[num_voters++] = (voter_t){ "Alice", 0 };
  voters[num_voters++] = (voter_t){ "Bob", 0 };
  voters[num_voters++] = (voter_t){ "Charlie", 0 };

  // Cast votes
  cast_vote(candidates, num_candidates, voters, num_voters, 1, 1);
  cast_vote(candidates, num_candidates, voters, num_voters, 2, 2);
  cast_vote(candidates, num_candidates, voters, num_voters, 3, 3);

  // Print the results
  print_results(candidates, num_candidates, voters, num_voters);

  return 0;
}