//Falcon-180B DATASET v1.0 Category: Personal Finance Planner ; Style: accurate
#include <stdio.h>
#include <stdlib.h>

#define MAX_BUDGET_ITEMS 100

typedef struct {
    char name[50];
    double amount;
    int category;
} BudgetItem;

void addBudgetItem(BudgetItem* budget, int numItems, char* name, double amount, int category) {
    if (numItems >= MAX_BUDGET_ITEMS) {
        printf("Error: Maximum number of budget items reached.\n");
        return;
    }

    strcpy(budget[numItems].name, name);
    budget[numItems].amount = amount;
    budget[numItems].category = category;

    numItems++;
}

void printBudget(BudgetItem* budget, int numItems) {
    printf("Budget:\n");
    for (int i = 0; i < numItems; i++) {
        printf("%s: $%.2f (Category %d)\n", budget[i].name, budget[i].amount, budget[i].category);
    }
}

void calculateTotalExpenses(BudgetItem* budget, int numItems, double* totalExpenses, int* numExpenses) {
    *totalExpenses = 0;
    *numExpenses = 0;

    for (int i = 0; i < numItems; i++) {
        if (budget[i].category == 1) {
            *totalExpenses += budget[i].amount;
            (*numExpenses)++;
        }
    }
}

int main() {
    BudgetItem budget[MAX_BUDGET_ITEMS];
    int numItems = 0;

    addBudgetItem(budget, numItems, "Rent", 1000, 1);
    addBudgetItem(budget, numItems, "Utilities", 200, 1);
    addBudgetItem(budget, numItems, "Groceries", 400, 1);
    addBudgetItem(budget, numItems, "Entertainment", 150, 2);
    addBudgetItem(budget, numItems, "Clothing", 100, 2);

    int numExpenses;
    double totalExpenses;

    calculateTotalExpenses(budget, numItems, &totalExpenses, &numExpenses);

    printf("Total expenses for necessary items: $%.2f\n", totalExpenses);
    printf("Number of necessary expenses: %d\n", numExpenses);

    return 0;
}