//Code Llama-13B DATASET v1.0 Category: Movie Rating System ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the movie rating system
#define MOVIE_RATING_SYSTEM "MPAA"

// Define the movie rating levels
#define MPAA_G "G"
#define MPAA_PG "PG"
#define MPAA_PG_13 "PG-13"
#define MPAA_R "R"
#define MPAA_NC_17 "NC-17"

// Define the movie rating descriptions
#define MPAA_G_DESC "All ages admitted."
#define MPAA_PG_DESC "Parents strongly cautioned. Some material may not be suitable for children under 13."
#define MPAA_PG_13_DESC "Some material may be inappropriate for children under 13."
#define MPAA_R_DESC "Under 17 requires accompanying parent or adult guardian."
#define MPAA_NC_17_DESC "No one 17 and under admitted."

// Define the movie rating colors
#define MPAA_G_COLOR "\e[32m"
#define MPAA_PG_COLOR "\e[33m"
#define MPAA_PG_13_COLOR "\e[33m"
#define MPAA_R_COLOR "\e[31m"
#define MPAA_NC_17_COLOR "\e[31m"

// Define the movie rating message
#define MPAA_MESSAGE "This movie is rated %s (%s) by the %s rating system."

// Define the movie rating function
void movieRating(char *rating) {
    if (strcmp(rating, MPAA_G) == 0) {
        printf(MPAA_G_COLOR MPAA_MESSAGE "\n", rating, MPAA_G_DESC, MOVIE_RATING_SYSTEM);
    } else if (strcmp(rating, MPAA_PG) == 0) {
        printf(MPAA_PG_COLOR MPAA_MESSAGE "\n", rating, MPAA_PG_DESC, MOVIE_RATING_SYSTEM);
    } else if (strcmp(rating, MPAA_PG_13) == 0) {
        printf(MPAA_PG_13_COLOR MPAA_MESSAGE "\n", rating, MPAA_PG_13_DESC, MOVIE_RATING_SYSTEM);
    } else if (strcmp(rating, MPAA_R) == 0) {
        printf(MPAA_R_COLOR MPAA_MESSAGE "\n", rating, MPAA_R_DESC, MOVIE_RATING_SYSTEM);
    } else if (strcmp(rating, MPAA_NC_17) == 0) {
        printf(MPAA_NC_17_COLOR MPAA_MESSAGE "\n", rating, MPAA_NC_17_DESC, MOVIE_RATING_SYSTEM);
    } else {
        printf("Invalid movie rating: %s\n", rating);
    }
}

int main() {
    char *rating = "G";
    movieRating(rating);
    return 0;
}