//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: inquisitive
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MIN_LENGTH 8 // Minimum length of password
#define MAX_LENGTH 20 // Maximum length of password

bool isValidPassword(char* password);
int getPasswordStrength(char* password);

int main() {
    char password[MAX_LENGTH+1];
    int strength = 0;

    printf("Enter a password: ");
    fgets(password, MAX_LENGTH+1, stdin);

    strength = getPasswordStrength(password);

    if (strength == 0) {
        printf("Password is too weak!\n");
    } else if (strength == 1) {
        printf("Password is weak.\n");
    } else if (strength == 2) {
        printf("Password is fair.\n");
    } else if (strength == 3) {
        printf("Password is good.\n");
    } else if (strength == 4) {
        printf("Password is strong.\n");
    } else {
        printf("Invalid password strength.\n");
    }

    return 0;
}

bool isValidPassword(char* password) {
    int length = strlen(password);

    if (length < MIN_LENGTH || length > MAX_LENGTH) {
        return false;
    }

    for (int i = 0; i < length; i++) {
        if (!isalnum(password[i])) {
            return false;
        }
    }

    return true;
}

int getPasswordStrength(char* password) {
    int length = strlen(password);
    int complexity = 0;
    int specialChars = 0;

    if (length < MIN_LENGTH) {
        return 0;
    }

    for (int i = 0; i < length; i++) {
        if (!isalnum(password[i])) {
            specialChars++;
        }
    }

    if (specialChars == 0) {
        return 0;
    } else if (specialChars == 1) {
        complexity++;
    } else if (specialChars > 1) {
        complexity += 2;
    }

    if (length >= 12) {
        complexity++;
    } else if (length >= 16) {
        complexity += 2;
    }

    return complexity;
}