//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define MAX_BUFFER_SIZE 1024
#define MAX_QUEUE_SIZE 10
#define KEY 12345
#define MSG_TYPE_REQUEST 1
#define MSG_TYPE_RESPONSE 2

typedef struct {
    long mtype;
    char buffer[MAX_BUFFER_SIZE];
} message_t;

int main() {
    int msgid;
    key_t key = KEY;
    message_t msg;
    char *buffer;

    // Create message queue
    msgid = msgget(key, 0666 | IPC_CREAT);
    if (msgid == -1) {
        perror("Failed to create message queue");
        exit(1);
    }

    // Initialize message buffer
    msg.mtype = MSG_TYPE_REQUEST;
    strcpy(msg.buffer, "Hello, world!");

    // Send message to queue
    if (msgsnd(msgid, &msg, sizeof(msg), 0) == -1) {
        perror("Failed to send message");
        exit(1);
    }

    // Receive message from queue
    msg.mtype = 0;
    if (msgrcv(msgid, &msg, sizeof(msg), MSG_TYPE_RESPONSE, 0) == -1) {
        perror("Failed to receive message");
        exit(1);
    }

    printf("Received response: %s\n", msg.buffer);

    // Remove message queue
    if (msgctl(msgid, IPC_RMID, NULL) == -1) {
        perror("Failed to remove message queue");
        exit(1);
    }

    return 0;
}