//Gemma-7B DATASET v1.0 Category: Hotel Management System ; Style: Cryptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ROOM_NUM 10
#define MAX_GUESTS 2

typedef struct Room {
    int room_num;
    char status;
    char guest_name[MAX_GUESTS];
    int num_guests;
} Room;

Room rooms[ROOM_NUM];

void initializeRooms() {
    for (int i = 0; i < ROOM_NUM; i++) {
        rooms[i].room_num = i + 1;
        rooms[i].status = 'O';
        rooms[i].num_guests = 0;
    }
}

void bookRoom(char *name, int numGuests) {
    for (int i = 0; i < ROOM_NUM; i++) {
        if (rooms[i].status == 'O' && rooms[i].num_guests < MAX_GUESTS) {
            rooms[i].status = 'B';
            rooms[i].num_guests = numGuests;
            strcpy(rooms[i].guest_name, name);
            return;
        }
    }

    printf("No available rooms.\n");
}

void listRooms() {
    for (int i = 0; i < ROOM_NUM; i++) {
        printf("Room %d: ", rooms[i].room_num);
        switch (rooms[i].status) {
            case 'O':
                printf("Occupied\n");
                break;
            case 'B':
                printf("Bookable\n");
                break;
            case 'F':
                printf("Free\n");
                break;
        }
    }
}

int main() {
    initializeRooms();

    bookRoom("John Doe", 2);
    bookRoom("Jane Doe", 1);
    listRooms();

    return 0;
}