//Gemma-7B DATASET v1.0 Category: Network Quality of Service (QoS) monitor ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>
#include <time.h>

#define MAX_PACKET_SIZE 1024
#define TIMEOUT_SEC 5

int main()
{
    int sockfd, newsockfd, clientlen, n, recv_len;
    struct sockaddr_in servaddr, cliaddr;
    struct timeval tv;
    char buffer[MAX_PACKET_SIZE];

    // Socket setup
    sockfd = socket(AF_INET, SOCK_STREAM, htons(8080));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Bind socket
    servaddr.sin_port = htons(8080);
    if (bind(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    // Wait for client connection
    clientlen = sizeof(cliaddr);
    newsockfd = accept(sockfd, (struct sockaddr *)&cliaddr, &clientlen);
    if (newsockfd < 0)
    {
        perror("Error accepting connection");
        exit(1);
    }

    // Set timeout
    tv.tv_sec = TIMEOUT_SEC;
    setsockopt(newsockfd, SOL_SOCKET, SO_RCVTIMEO, &tv, sizeof(tv));

    // Receive data
    recv_len = recv(newsockfd, buffer, MAX_PACKET_SIZE, 0);
    if (recv_len < 0)
    {
        perror("Error receiving data");
        exit(1);
    }

    // Print data
    printf("Received data: %s\n", buffer);

    // Close connection
    close(newsockfd);
    close(sockfd);

    return 0;
}