//Falcon-180B DATASET v1.0 Category: Memory management ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define HEAP_SIZE 1000

typedef struct block {
    size_t size;
    int free;
    struct block *next;
} Block;

Block *freeList = (void*)0;
char heap[HEAP_SIZE];

void init() {
    freeList = (Block*)heap;
    freeList->size = HEAP_SIZE - sizeof(Block);
    freeList->free = 1;
    freeList->next = (void*)0;
}

void *malloc(size_t num) {
    Block *current = freeList;
    while ((current->size < num) && (current->next!= NULL))
        current = current->next;

    if (current->size == num) {
        current->free = 0;
        return (void*)(++current);
    } else if (current->size > num) {
        Block *newBlock = (void*)((void*)current + num + sizeof(Block));
        newBlock->size = current->size - num - sizeof(Block);
        newBlock->free = 1;
        newBlock->next = current->next;
        current->size = num;
        current->free = 0;
        current->next = newBlock;
        return (void*)(++current);
    }
    return NULL;
}

void free(void* ptr) {
    if (ptr < heap || ptr >= (heap + HEAP_SIZE))
        return;

    Block* blk = (Block*)ptr;
    --blk;
    blk->free = 1;
}

int main() {
    srand(time(NULL));
    init();

    int* a = (int*)malloc(sizeof(int));
    int* b = (int*)malloc(sizeof(int));
    int* c = (int*)malloc(sizeof(int));

    *a = rand() % 100;
    *b = rand() % 100;
    *c = rand() % 100;

    printf("a = %d, b = %d, c = %d\n", *a, *b, *c);

    free(a);
    free(b);
    free(c);

    return 0;
}