//Falcon-180B DATASET v1.0 Category: Network Quality of Service (QoS) monitor ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PACKETS 100
#define MAX_PACKET_SIZE 1024

typedef struct {
    int id;
    int size;
    int priority;
} packet_t;

packet_t packets[MAX_PACKETS];
int packet_count = 0;

void add_packet(int id, int size, int priority) {
    if (packet_count >= MAX_PACKETS) {
        printf("Error: Maximum number of packets reached!\n");
        exit(1);
    }

    packets[packet_count].id = id;
    packets[packet_count].size = size;
    packets[packet_count].priority = priority;

    packet_count++;
}

void remove_packet(int id) {
    int i;

    for (i = 0; i < packet_count; i++) {
        if (packets[i].id == id) {
            memmove(&packets[i], &packets[i+1], sizeof(packet_t) * (packet_count - i - 1));
            packet_count--;
            break;
        }
    }
}

int main() {
    int i, j, k, l, m, n, o;

    add_packet(1, 512, 1);
    add_packet(2, 1024, 2);
    add_packet(3, 2048, 3);

    for (i = 0; i < packet_count; i++) {
        printf("ID: %d, Size: %d bytes, Priority: %d\n", packets[i].id, packets[i].size, packets[i].priority);
    }

    remove_packet(2);

    for (i = 0; i < packet_count; i++) {
        printf("ID: %d, Size: %d bytes, Priority: %d\n", packets[i].id, packets[i].size, packets[i].priority);
    }

    return 0;
}