//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>

// Let's get the party started with our very own C Socket programming example! 🚀
int main() {
  // First, let's create a socket. It's like a virtual doorway for our data to flow through. 🚪
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    // Oops, socket creation failed! Let's inform the user. 😞
    perror("Socket creation failed");
    return -1;
  }

  // Now, let's set up the address we want to connect to. Think of it as giving our data a destination. 🌎
  struct sockaddr_in serv_addr;
  memset(&serv_addr, 0, sizeof(serv_addr));  // Clear the address structure
  serv_addr.sin_family = AF_INET;          // We're using the IPv4 address family
  serv_addr.sin_port = htons(80);          // We're targeting port 80, where HTTP usually lives
  serv_addr.sin_addr.s_addr = INADDR_ANY;   // Any IP address will do

  // Great! Time to connect our socket to the server. Let's shake hands! 🤝
  if (connect(sockfd, (struct sockaddr *) & serv_addr, sizeof(serv_addr)) < 0) {
    // Oh no, connection failed! Let's tell the user. 😔
    perror("Connection failed");
    return -1;
  }

  // We're connected! Let's send some data. 🗣️
  char *message = "Hello, world!";
  int sent_bytes = send(sockfd, message, strlen(message), 0);
  if (sent_bytes < 0) {
    // Oops, sending data failed! Let's report it. 😖
    perror("Send failed");
    return -1;
  }

  // Now, let's listen eagerly for a response. 👂
  char buffer[256];
  int received_bytes = recv(sockfd, buffer, sizeof(buffer), 0);
  if (received_bytes < 0) {
    // Oh no, receiving data failed! Let's inform the user. 😟
    perror("Receive failed");
    return -1;
  }

  // Yay! We received data. Let's show it to the world. 🌍
  printf("Server says: %s\n", buffer);

  // Finally, let's clean up after ourselves. 🧹
  close(sockfd);

  return 0;
}