//GPT-4o-mini DATASET v1.0 Category: Building a IMAP Client ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

#define MAX_BUFFER_SIZE 4096

struct memory {
    char *response;
    size_t size;
};

static size_t write_callback(void *ptr, size_t size, size_t nmemb, struct memory *mem) {
    size_t total_size = size * nmemb;
    char *temp_response = realloc(mem->response, mem->size + total_size + 1);
    if (temp_response == NULL) {
        printf("Failed to allocate memory.\n");
        return 0;
    }

    mem->response = temp_response;
    memcpy(&(mem->response[mem->size]), ptr, total_size);
    mem->size += total_size;
    mem->response[mem->size] = '\0';
    
    return total_size;
}

void fetch_email_headers(const char *username, const char *password, const char *server) {
    CURL *curl;
    CURLcode res;
    struct memory chunk;

    chunk.response = malloc(1);  // Initial allocation
    chunk.size = 0;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();
    if (curl) {
        char url[256];
        snprintf(url, sizeof(url), "imap://%s/INBOX", server);

        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_USERPWD, username);
        curl_easy_setopt(curl, CURLOPT_PASSWORD, password);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_callback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, (void *)&chunk);
        curl_easy_setopt(curl, CURLOPT_VERBOSE, 1L); // Enable verbose mode

        res = curl_easy_perform(curl);
        if (res != CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
        } else {
            printf("Email headers fetched successfully:\n%s\n", chunk.response);
        }

        curl_easy_cleanup(curl);
    }

    free(chunk.response);
    curl_global_cleanup();
}

int main(int argc, char *argv[]) {
    if (argc != 4) {
        fprintf(stderr, "Usage: %s <username> <password> <server>\n", argv[0]);
        return EXIT_FAILURE;
    }

    const char *username = argv[1];
    const char *password = argv[2];
    const char *server = argv[3];

    fetch_email_headers(username, password, server);

    return EXIT_SUCCESS;
}