//GEMINI-pro DATASET v1.0 Category: Building a SMTP Client ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main()
{
  char *hostname = "smtp.example.com";
  int port = 25;
  char *user = "username";
  char *password = "password";
  char *from = "from@example.com";
  char *to = "to@example.com";
  char *subject = "Hello World!";
  char *body = "This is a test email.";

  // Create a socket
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0)
  {
    perror("socket");
    return 1;
  }

  // Connect to the SMTP server
  struct sockaddr_in serveraddr;
  memset(&serveraddr, 0, sizeof(serveraddr));
  serveraddr.sin_family = AF_INET;
  serveraddr.sin_port = htons(port);
  if (inet_pton(AF_INET, hostname, &serveraddr.sin_addr) <= 0)
  {
    perror("inet_pton");
    return 1;
  }
  if (connect(sockfd, (struct sockaddr *)&serveraddr, sizeof(serveraddr)) < 0)
  {
    perror("connect");
    return 1;
  }

  // Read the welcome message
  char buffer[1024];
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the HELO command
  sprintf(buffer, "HELO %s\r\n", hostname);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the HELO response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the AUTH LOGIN command
  sprintf(buffer, "AUTH LOGIN\r\n");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the AUTH LOGIN response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the username
  sprintf(buffer, "%s\r\n", user);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the username response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the password
  sprintf(buffer, "%s\r\n", password);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the password response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the MAIL FROM command
  sprintf(buffer, "MAIL FROM: <%s>\r\n", from);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the MAIL FROM response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the RCPT TO command
  sprintf(buffer, "RCPT TO: <%s>\r\n", to);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the RCPT TO response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the DATA command
  sprintf(buffer, "DATA\r\n");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the DATA response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the email
  sprintf(buffer, "From: %s\r\n", from);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }
  sprintf(buffer, "To: %s\r\n", to);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }
  sprintf(buffer, "Subject: %s\r\n", subject);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }
  sprintf(buffer, "%s\r\n", body);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Send the end of the email
  sprintf(buffer, ".\r\n");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the email response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Send the QUIT command
  sprintf(buffer, "QUIT\r\n");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0)
  {
    perror("send");
    return 1;
  }

  // Read the QUIT response
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0)
  {
    perror("recv");
    return 1;
  }
  printf("%s", buffer);

  // Close the socket
  close(sockfd);

  return 0;
}