//MISTRAL-7B DATASET v1.0 Category: Arithmetic ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define a custom data structure for complex numbers
typedef struct Complex {
    double real;
    double imag;
} Complex;

// Function to add two complex numbers
Complex complexAdd(Complex num1, Complex num2) {
    Complex result;
    result.real = num1.real + num2.real;
    result.imag = num1.imag + num2.imag;
    return result;
}

// Function to subtract two complex numbers
Complex complexSubtract(Complex num1, Complex num2) {
    Complex result;
    result.real = num1.real - num2.real;
    result.imag = num1.imag - num2.imag;
    return result;
}

// Function to multiply two complex numbers
Complex complexMultiply(Complex num1, Complex num2) {
    Complex result;
    result.real = (num1.real * num2.real) - (num1.imag * num2.imag);
    result.imag = (num1.real * num2.imag) + (num1.imag * num2.real);
    return result;
}

// Function to print a complex number
void printComplex(Complex num) {
    printf("%.2f + %.2fi", num.real, num.imag);
}

// Generate a random complex number
Complex generateRandomComplexNumber() {
    Complex num;
    num.real = (double) rand() / RAND_MAX * 10.0;
    num.imag = (double) rand() / RAND_MAX * 10.0;
    return num;
}

int main() {
    srand(time(NULL));

    // Generate two random complex numbers
    Complex num1 = generateRandomComplexNumber();
    Complex num2 = generateRandomComplexNumber();

    // Print the generated complex numbers
    printf("Random Complex Number 1: ");
    printComplex(num1);
    printf("\n");
    printf("Random Complex Number 2: ");
    printComplex(num2);
    printf("\n");

    // Perform addition, subtraction and multiplication of complex numbers
    Complex sum = complexAdd(num1, num2);
    Complex difference = complexSubtract(num1, num2);
    Complex product = complexMultiply(num1, num2);

    // Print the results of the operations
    printf("Sum of Complex Numbers: ");
    printComplex(sum);
    printf("\n");
    printf("Difference of Complex Numbers: ");
    printComplex(difference);
    printf("\n");
    printf("Product of Complex Numbers: ");
    printComplex(product);
    printf("\n");

    return 0;
}