//Falcon-180B DATASET v1.0 Category: Greedy Algorithms ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 1000

// Function to find the maximum value of a given array
int find_max(int arr[], int size) {
    int max = arr[0];
    for (int i = 1; i < size; i++) {
        if (arr[i] > max) {
            max = arr[i];
        }
    }
    return max;
}

// Function to implement the greedy algorithm for the knapsack problem
int knapsack_greedy(int weights[], int values[], int n, int capacity) {
    int w[n], v[n];
    for (int i = 0; i < n; i++) {
        w[i] = weights[i];
        v[i] = values[i];
    }

    // Sort the items in decreasing order of value-to-weight ratio
    for (int i = 0; i < n - 1; i++) {
        for (int j = i + 1; j < n; j++) {
            if (v[j] / w[j] > v[i] / w[i]) {
                int temp_w = w[i];
                int temp_v = v[i];
                w[i] = w[j];
                v[i] = v[j];
                w[j] = temp_w;
                v[j] = temp_v;
            }
        }
    }

    int total_value = 0;
    int num_items = 0;
    for (int i = 0; i < n; i++) {
        if (w[i] <= capacity) {
            total_value += v[i];
            capacity -= w[i];
            num_items++;
        }
    }

    return total_value;
}

int main() {
    int weights[] = {10, 20, 30};
    int values[] = {60, 100, 120};
    int n = sizeof(weights) / sizeof(weights[0]);
    int capacity = 50;

    int max_value = find_max(values, n);
    int greedy_value = knapsack_greedy(weights, values, n, capacity);

    printf("Maximum value: %d\n", max_value);
    printf("Greedy algorithm value: %d\n", greedy_value);

    return 0;
}