//Gemma-7B DATASET v1.0 Category: Medical Store Management System ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct Item {
    char name[50];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void addItem(Item item) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            items[i] = item;
            return;
        }
    }
    printf("Error: Inventory full.\n");
}

void updateQuantity(char name, int quantity) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity = quantity;
            return;
        }
    }
    printf("Error: Item not found.\n");
}

void calculateTotalCost(Item item) {
    float totalCost = item.quantity * item.price;
    printf("Total cost: %.2f\n", totalCost);
}

int main() {
    Item item1 = {"Item 1", 10, 10.0};
    addItem(item1);

    Item item2 = {"Item 2", 5, 20.0};
    addItem(item2);

    updateQuantity("Item 1", 15);

    calculateTotalCost(item1);

    return 0;
}