//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/ioctl.h>

#define ROBOT_DEV "/dev/ttyUSB0"
#define ROBOT_SPEED 115200

int main(int argc, char **argv)
{
    int fd;
    struct termios tio;

    // Open the serial port
    fd = open(ROBOT_DEV, O_RDWR | O_NOCTTY);
    if (fd < 0) {
        perror("open");
        exit(1);
    }

    // Configure the serial port
    tcgetattr(fd, &tio);
    cfsetospeed(&tio, ROBOT_SPEED);
    cfsetispeed(&tio, ROBOT_SPEED);
    tio.c_cflag |= (CLOCAL | CREAD);
    tio.c_cflag &= ~PARENB;
    tio.c_cflag &= ~CSTOPB;
    tio.c_cflag &= ~CSIZE;
    tio.c_cflag |= CS8;
    tio.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);
    tio.c_oflag &= ~OPOST;
    tcsetattr(fd, TCSANOW, &tio);

    // Send a command to the robot
    char *command = "F100";
    int len = strlen(command);
    write(fd, command, len);

    // Read the response from the robot
    char buf[256];
    int n = read(fd, buf, sizeof(buf));
    if (n < 0) {
        perror("read");
        exit(1);
    }

    // Print the response
    printf("%s", buf);

    // Close the serial port
    close(fd);

    return 0;
}