//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[50];
    int quantity;
    double price;
} Item;

Item items[MAX_ITEMS];

void addItem(char *name, int quantity, double price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Item limit exceeded.\n");
}

double calculateTotal(int numItems) {
    double total = 0.0;
    for (int i = 0; i < numItems; i++) {
        total += items[i].quantity * items[i].price;
    }

    return total;
}

void generateBill() {
    printf("------------------------------------------------------------------------\n");
    printf("           C Cafe Billing System\n");
    printf("------------------------------------------------------------------------\n");

    int numItems = 0;
    for (int i = 0; items[i].name[0] != '\0'; i++) {
        numItems++;
    }

    printf("Number of items: %d\n", numItems);

    double total = calculateTotal(numItems);
    printf("Total: %.2lf\n", total);

    printf("------------------------------------------------------------------------\n");
    printf("Thank you for your visit to C Cafe!\n");
    printf("------------------------------------------------------------------------\n");
}

int main() {
    addItem("Coffee", 10, 5.0);
    addItem("Tea", 8, 3.0);
    addItem("Juice", 6, 2.0);

    generateBill();

    return 0;
}