//MISTRAL-7B DATASET v1.0 Category: Cryptographic hash function ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/sha.h>

#define BLOCK_SIZE 64
#define HASH_SIZE SHA256_DIGEST_LENGTH

typedef struct GratefulHash {
    unsigned char hash[HASH_SIZE];
} GratefulHash;

void GratefulHash_Init(GratefulHash *hash) {
    memset(hash->hash, 0, HASH_SIZE);
}

void GratefulHash_Update(GratefulHash *hash, const void *data, size_t len) {
    SHA256_CTX sha256;
    unsigned char block[BLOCK_SIZE];

    SHA256_Init(&sha256);
    SHA256_Update(&sha256, data, len);

    if (len % BLOCK_SIZE != 0) {
        size_t remaining = len % BLOCK_SIZE;
        memcpy(block, data + len - remaining, remaining);
        SHA256_Update(&sha256, block, remaining);
    }

    SHA256_Final(hash->hash, &sha256);
}

void GratefulHash_Finalize(GratefulHash *hash) {
    SHA256_CTX sha256;
    unsigned char padding[8];
    size_t padding_len = HASH_SIZE + 8;

    memset(padding, 0x80, 1);
    padding[0] = 0x36;
    SHA256_Init(&sha256);
    SHA256_Update(&sha256, hash->hash, HASH_SIZE);
    SHA256_Update(&sha256, padding, 8);

    SHA256_Final(hash->hash, &sha256);
}

void GratefulHash_Print(const GratefulHash *hash) {
    for (int i = 0; i < HASH_SIZE; ++i) {
        printf("%02x", hash->hash[i]);
    }
    printf("\n");
}

int main() {
    GratefulHash hash;
    GratefulHash_Init(&hash);

    const char *message = "I am grateful for your time and effort in helping me understand cryptographic hash functions better.";

    GratefulHash_Update(&hash, message, strlen(message));
    GratefulHash_Finalize(&hash);

    GratefulHash_Print(&hash);

    return 0;
}