//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <net/ethernet.h>

#define SNAPLEN 1514
#define TRUE   1
#define FALSE  0

typedef struct {
    u_char *data;
    int len;
} packet_t;

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    packet_t *pkt = (packet_t *) args;
    pkt->data = packet;
    pkt->len = header->len;
}

int main(int argc, char *argv[]) {
    char *dev = argv[1];
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    bpf_u_int32 netp, maskp;
    char filter_exp[] = "ip";

    // Open the network device for capturing packets
    handle = pcap_open_live(dev, SNAPLEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error: %s\n", errbuf);
        exit(1);
    }

    // Compile the filter expression
    if (pcap_compile(handle, &netp, filter_exp, 1, 0)!= 0) {
        fprintf(stderr, "Error: failed to compile filter expression\n");
        exit(1);
    }

    // Set the filter for the capture session
    if (pcap_setfilter(handle, &netp)!= 0) {
        fprintf(stderr, "Error: failed to set filter\n");
        exit(1);
    }

    // Register a callback function to handle incoming packets
    pcap_loop(handle, -1, packet_handler, NULL);

    return 0;
}